/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.cmd;

import com.sina.weibo.sdk.cmd.AppInstallCmd;
import com.sina.weibo.sdk.cmd.AppInvokeCmd;
import com.sina.weibo.sdk.cmd.BaseCmd;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.utils.LogUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CmdInfo {
    private static final String TAG = BaseCmd.class.getName();
    private List<AppInstallCmd> mInstallCmds;
    private List<AppInvokeCmd> mInvokeCmds;
    private int frequency;

    public CmdInfo(String jsonStr) throws WeiboException {
        this.initFromJsonStr(jsonStr);
    }

    private void initFromJsonStr(String jsonStr) throws WeiboException {
        if (jsonStr == null) {
            return;
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("error") || jsonObj.has("error_code")) {
                LogUtil.w(TAG, "load cmd api has error !!!");
                throw new WeiboException("load cmd api has error !!!");
            }
            JSONObject cmdJsonObj = jsonObj.optJSONObject("cmd");
            if (cmdJsonObj != null) {
                JSONArray invokeCmdArray;
                this.frequency = cmdJsonObj.optInt("frequency");
                JSONArray installCmdArray = cmdJsonObj.optJSONArray("app_install");
                if (installCmdArray != null) {
                    this.mInstallCmds = new ArrayList<AppInstallCmd>();
                    int i = 0;
                    while (i < installCmdArray.length()) {
                        JSONObject installCmdJsonObj = installCmdArray.getJSONObject(i);
                        this.mInstallCmds.add(new AppInstallCmd(installCmdJsonObj));
                        ++i;
                    }
                }
                if ((invokeCmdArray = cmdJsonObj.optJSONArray("app_invoke")) != null) {
                    this.mInvokeCmds = new ArrayList<AppInvokeCmd>();
                    int i = 0;
                    while (i < invokeCmdArray.length()) {
                        JSONObject invokeCmdJsonObj = invokeCmdArray.getJSONObject(i);
                        this.mInvokeCmds.add(new AppInvokeCmd(invokeCmdJsonObj));
                        ++i;
                    }
                }
            }
        }
        catch (JSONException e) {
            LogUtil.d(TAG, "parse NotificationInfo error: " + e.getMessage());
        }
    }

    public List<AppInstallCmd> getInstallCmds() {
        return this.mInstallCmds;
    }

    public void setInstallCmds(List<AppInstallCmd> mInstallCmds) {
        this.mInstallCmds = mInstallCmds;
    }

    public List<AppInvokeCmd> getInvokeCmds() {
        return this.mInvokeCmds;
    }

    public void setInvokeCmds(List<AppInvokeCmd> mInvokeCmds) {
        this.mInvokeCmds = mInvokeCmds;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }
}

