/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.cmd;

import com.sina.weibo.sdk.exception.WeiboException;
import org.json.JSONException;
import org.json.JSONObject;

class BaseCmd {
    private String mNotificationText;
    private String mNotificationTitle;
    private long mNotificationDelay;

    public BaseCmd() {
    }

    public BaseCmd(String jsonStr) throws WeiboException {
        this.initFromJsonStr(jsonStr);
    }

    public BaseCmd(JSONObject jsonObj) {
        this.initFromJsonObj(jsonObj);
    }

    protected void initFromJsonStr(String jsonStr) throws WeiboException {
        if (jsonStr == null) {
            return;
        }
        JSONObject jsonObj = null;
        try {
            jsonObj = new JSONObject(jsonStr);
            this.initFromJsonObj(jsonObj);
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new WeiboException("pase cmd has error !!!");
        }
    }

    protected void initFromJsonObj(JSONObject jsonObj) {
        this.mNotificationText = jsonObj.optString("notification_text");
        this.mNotificationTitle = jsonObj.optString("notification_title");
        this.mNotificationDelay = jsonObj.optLong("notification_delay");
    }

    public String getNotificationText() {
        return this.mNotificationText;
    }

    public void setNotificationText(String mNotificationText) {
        this.mNotificationText = mNotificationText;
    }

    public String getNotificationTitle() {
        return this.mNotificationTitle;
    }

    public void setNotificationTitle(String mNotificationTitle) {
        this.mNotificationTitle = mNotificationTitle;
    }

    public long getNotificationDelay() {
        return this.mNotificationDelay;
    }

    public void setNotificationDelay(long mNotificationDelay) {
        this.mNotificationDelay = mNotificationDelay;
    }
}

