/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api.share.ui;

import android.content.Context;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.EditText;
import java.util.ArrayList;
import java.util.List;

public class EditBlogView
extends EditText {
    private Context ctx;
    private List<OnSelectionListener> listeners;
    private int count;
    private OnEnterListener mOnEnterListener;
    private boolean canSelectionChanged = true;

    public EditBlogView(Context context) {
        super(context);
        this.init();
    }

    public EditBlogView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EditBlogView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.ctx = this.getContext();
        this.listeners = new ArrayList<OnSelectionListener>();
    }

    public void setOnSelectionListener(OnSelectionListener listener) {
        this.listeners.add(listener);
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (!this.canSelectionChanged || this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        for (OnSelectionListener l : this.listeners) {
            l.onSelectionChanged(selStart, selEnd);
        }
    }

    public void enableSelectionChanged(boolean enable) {
        this.canSelectionChanged = enable;
    }

    public void setOnEnterListener(OnEnterListener listener) {
        this.mOnEnterListener = listener;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 66 && this.mOnEnterListener != null) {
            this.mOnEnterListener.onEnterKey();
        }
        return super.onKeyDown(keyCode, event);
    }

    public int correctPosition(int pos) {
        if (pos == -1) {
            return pos;
        }
        Editable editable = this.getText();
        int length = editable.length();
        if (pos >= length) {
            return pos;
        }
        Object[] objs = editable.getSpans(pos, pos, ImageSpan.class);
        if (objs != null && objs.length != 0 && pos != editable.getSpanStart(objs[0])) {
            return editable.getSpanEnd(objs[0]);
        }
        return pos;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnectionWrapper inputConnection = new InputConnectionWrapper(super.onCreateInputConnection(outAttrs), false){

            public boolean commitText(CharSequence text, int newCursorPosition) {
                Editable content = EditBlogView.this.getEditableText();
                String oldText = new String(content.toString());
                int start = Selection.getSelectionStart((CharSequence)content);
                int end = Selection.getSelectionEnd((CharSequence)content);
                if (start != -1 && end != -1) {
                    int correctEnd;
                    int correctStart = EditBlogView.this.correctPosition(start);
                    if (correctStart > (correctEnd = EditBlogView.this.correctPosition(end))) {
                        int temp = correctStart;
                        correctStart = correctEnd;
                        correctEnd = temp;
                    }
                    if (correctStart != start || correctEnd != end) {
                        Selection.setSelection((Spannable)content, (int)correctStart, (int)correctEnd);
                    }
                    if (correctStart != correctEnd) {
                        EditBlogView.this.getText().delete(correctStart, correctEnd);
                    }
                }
                return super.commitText(text, newCursorPosition);
            }

            public boolean setComposingText(CharSequence text, int newCursorPosition) {
                Editable content = EditBlogView.this.getEditableText();
                String oldText = new String(content.toString());
                int start = Selection.getSelectionStart((CharSequence)content);
                int end = Selection.getSelectionEnd((CharSequence)content);
                if (start != -1 && end != -1) {
                    int correctEnd;
                    int correctStart = EditBlogView.this.correctPosition(start);
                    if (correctStart > (correctEnd = EditBlogView.this.correctPosition(end))) {
                        int temp = correctStart;
                        correctStart = correctEnd;
                        correctEnd = temp;
                    }
                    if (correctStart != start || correctEnd != end) {
                        Selection.setSelection((Spannable)content, (int)correctStart, (int)correctEnd);
                    }
                    if (correctStart != correctEnd) {
                        EditBlogView.this.getText().delete(correctStart, correctEnd);
                    }
                }
                return super.setComposingText(text, newCursorPosition);
            }
        };
        return inputConnection;
    }

    public static interface OnEnterListener {
        public void onEnterKey();
    }

    public static interface OnSelectionListener {
        public void onSelectionChanged(int var1, int var2);
    }
}

