/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.open.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.view.MotionEvent;
import com.tencent.open.a.f;
import com.tencent.open.utils.Global;
import com.tencent.open.utils.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.List;

public class SystemUtils {
    public static final String QQ_VERSION_NAME_4_2_0 = "4.2.0";
    public static final String QQ_VERSION_NAME_4_3_0 = "4.3.0";
    public static final String QQ_VERSION_NAME_4_5_0 = "4.5.0";
    public static final String QQ_VERSION_NAME_4_6_0 = "4.6.0";
    public static final String QQ_VERSION_NAME_5_0_0 = "5.0.0";
    public static final String QQ_VERSION_NAME_5_1_0 = "5.1.0";
    public static final String QQ_VERSION_NAME_5_2_0 = "5.2.0";
    public static final String QQ_VERSION_NAME_5_3_0 = "5.3.0";
    public static final String QQ_VERSION_NAME_5_9_5 = "5.9.5";
    public static final String QQ_SHARE_CALLBACK_ACTION = "shareToQQ";
    public static final String QZONE_SHARE_CALLBACK_ACTION = "shareToQzone";
    public static final String QQFAVORITES_CALLBACK_ACTION = "addToQQFavorites";
    public static final String QQDATALINE_CALLBACK_ACTION = "sendToMyComputer";
    public static final String TROOPBAR_CALLBACK_ACTION = "shareToTroopBar";
    public static final String ACTION_LOGIN = "action_login";
    public static final String ACTION_SHARE = "action_share";
    public static final String IS_LOGIN = "is_login";
    public static final String IS_QQ_MOBILE_SHARE = "is_qq_mobile_share";
    public static final String H5_SHARE_DATA = "h5_share_data";
    public static final String ACTION_REQUEST_API = "action_request";

    public static String getAppVersionName(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static int compareVersion(String string, String string2) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string != null && string2 == null) {
            return 1;
        }
        if (string == null && string2 != null) {
            return -1;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        try {
            int n2;
            for (n2 = 0; n2 < stringArray.length && n2 < stringArray2.length; ++n2) {
                int n3;
                int n4 = Integer.parseInt(stringArray[n2]);
                if (n4 < (n3 = Integer.parseInt(stringArray2[n2]))) {
                    return -1;
                }
                if (n4 <= n3) continue;
                return 1;
            }
            if (stringArray.length > n2) {
                return 1;
            }
            if (stringArray2.length > n2) {
                return -1;
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            return string.compareTo(string2);
        }
    }

    public static boolean isAppSignatureValid(Context context, String string, String string2) {
        PackageInfo packageInfo;
        f.a("openSDK_LOG.SystemUtils", "OpenUi, validateAppSignatureForPackage");
        try {
            packageInfo = context.getPackageManager().getPackageInfo(string, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
        for (Signature signature : packageInfo.signatures) {
            String string3 = Util.encrypt(signature.toCharsString());
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String getAppSignatureMD5(Context context, String string) {
        f.a("openSDK_LOG.SystemUtils", "OpenUi, getSignValidString");
        String string2 = "";
        try {
            String string3 = context.getPackageName();
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string3, 64);
            Signature[] signatureArray = packageInfo.signatures;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(signatureArray[0].toByteArray());
            String string4 = Util.toHexString(messageDigest.digest());
            messageDigest.reset();
            f.a("openSDK_LOG.SystemUtils", "-->sign: " + string4);
            String string5 = string3 + "_" + string4 + "_" + string + "";
            messageDigest.update(Util.getBytesUTF8(string5));
            string2 = Util.toHexString(messageDigest.digest());
            messageDigest.reset();
            f.a("openSDK_LOG.SystemUtils", "-->signEncryped: " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            f.b("openSDK_LOG.SystemUtils", "OpenUi, getSignValidString error", exception);
        }
        return string2;
    }

    public static boolean isActivityExist(Context context, Intent intent) {
        if (context == null || intent == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 0);
        return list.size() != 0;
    }

    public static String getRealPathFromUri(Activity activity, Uri uri) {
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = activity.managedQuery(uri, stringArray, null, null, null);
        if (cursor != null) {
            int n2 = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(n2);
        }
        return null;
    }

    public static String getAppName(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        return ((Object)applicationInfo.loadLabel(context.getPackageManager())).toString();
    }

    public static int compareQQVersion(Context context, String string) {
        String string2 = SystemUtils.getAppVersionName(context, "com.tencent.mobileqq");
        return SystemUtils.compareVersion(string2, string);
    }

    public static boolean checkMobileQQ(Context context) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo("com.tencent.mobileqq", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            f.b("openSDK_LOG.SystemUtils", "checkMobileQQ NameNotFoundException", nameNotFoundException);
            nameNotFoundException.printStackTrace();
        }
        if (packageInfo != null) {
            String string = packageInfo.versionName;
            try {
                f.b("MobileQQ verson", string);
                String[] stringArray = string.split("\\.");
                int n2 = Integer.parseInt(stringArray[0]);
                int n3 = Integer.parseInt(stringArray[1]);
                return n2 > 4 || n2 == 4 && n3 >= 1;
            }
            catch (Exception exception) {
                f.b("openSDK_LOG.SystemUtils", "checkMobileQQ Exception", exception);
                exception.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static int getAndroidSDKVersion() {
        int n2 = 0;
        try {
            n2 = Integer.valueOf(Build.VERSION.SDK);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public static boolean isSupportMultiTouch() {
        Method[] methodArray;
        boolean bl = false;
        boolean bl2 = false;
        for (Method method : methodArray = MotionEvent.class.getDeclaredMethods()) {
            if (method.getName().equals("getPointerCount")) {
                bl = true;
            }
            if (!method.getName().equals("getPointerId")) continue;
            bl2 = true;
        }
        return SystemUtils.getAndroidSDKVersion() >= 7 || bl && bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"SdCardPath"})
    public static boolean extractSecureLib(String string, String string2, int n2) {
        Object object;
        f.c("openSDK_LOG.SystemUtils", "-->extractSecureLib, libName: " + string);
        Context context = Global.getContext();
        if (context == null) {
            f.c("openSDK_LOG.SystemUtils", "-->extractSecureLib, global context is null. ");
            return false;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("secure_lib", 0);
        File file = new File(context.getFilesDir(), string2);
        if (!file.exists()) {
            object = file.getParentFile();
            if (object != null && ((File)object).mkdirs()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else {
            int n3 = sharedPreferences.getInt("version", 0);
            f.c("openSDK_LOG.SystemUtils", "-->extractSecureLib, libVersion: " + n2 + " | oldVersion: " + n3);
            if (n2 == n3) {
                return true;
            }
        }
        object = null;
        OutputStream outputStream = null;
        try {
            object = context.getAssets().open(string);
            outputStream = context.openFileOutput(string2, 0);
            SystemUtils.a((InputStream)object, outputStream);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt("version", n2);
            editor.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            f.b("openSDK_LOG.SystemUtils", "-->extractSecureLib, when copy lib execption.", exception);
        }
        finally {
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    @SuppressLint(value={"SdCardPath"})
    public static boolean isLibExtracted(String string, int n2) {
        Context context = Global.getContext();
        if (context == null) {
            f.c("openSDK_LOG.SystemUtils", "-->isSecureLibExtracted, global context is null. ");
            return false;
        }
        File file = new File(context.getFilesDir(), string);
        SharedPreferences sharedPreferences = context.getSharedPreferences("secure_lib", 0);
        if (file.exists()) {
            int n3 = sharedPreferences.getInt("version", 0);
            f.c("openSDK_LOG.SystemUtils", "-->extractSecureLib, libVersion: " + n2 + " | oldVersion: " + n3);
            if (n2 == n3) {
                return true;
            }
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt("version", n2);
            editor.commit();
        }
        return false;
    }

    private static long a(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l2 = 0L;
        int n2 = 0;
        byte[] byArray = new byte[8192];
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        f.c("openSDK_LOG.SystemUtils", "-->copy, copyed size is: " + l2);
        return l2;
    }

    public static int getRequestCodeFromCallback(String string) {
        if (QQ_SHARE_CALLBACK_ACTION.equals(string)) {
            return 10103;
        }
        if (QZONE_SHARE_CALLBACK_ACTION.equals(string)) {
            return 10104;
        }
        if (QQFAVORITES_CALLBACK_ACTION.equals(string)) {
            return 10105;
        }
        if (QQDATALINE_CALLBACK_ACTION.equals(string)) {
            return 10106;
        }
        if (TROOPBAR_CALLBACK_ACTION.equals(string)) {
            return 10107;
        }
        if (ACTION_LOGIN.equals(string)) {
            return 11101;
        }
        if (ACTION_REQUEST_API.equals(string)) {
            return 10100;
        }
        return -1;
    }

    public static String getActionFromRequestcode(int n2) {
        if (n2 == 10103) {
            return QQ_SHARE_CALLBACK_ACTION;
        }
        if (n2 == 10104) {
            return QZONE_SHARE_CALLBACK_ACTION;
        }
        if (n2 == 10105) {
            return QQFAVORITES_CALLBACK_ACTION;
        }
        if (n2 == 10106) {
            return QQDATALINE_CALLBACK_ACTION;
        }
        if (n2 == 10107) {
            return TROOPBAR_CALLBACK_ACTION;
        }
        if (n2 == 11101) {
            return ACTION_LOGIN;
        }
        if (n2 == 10100) {
            return ACTION_REQUEST_API;
        }
        return null;
    }
}

