/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Environment;
import android.text.TextUtils;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.umeng.socialize.net.utils.AesHelper;
import com.umeng.socialize.net.utils.UResponse;
import com.umeng.socialize.utils.DeviceConfig;
import com.umeng.socialize.utils.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Stack;

public class SocialResHelper {
    private static final String TAG = "SocialResHelper";
    public static boolean RESUTIL_V2_DUBUG = false;
    private static final long EXTERNAL_CACHE_SIZE = 0x6400000L;
    private static final long INTERNAL_CACHE_SIZE = 0xA00000L;
    private static final String CACHE_PATH = "/download/.um/";

    private static String getMd5FileName(String string) {
        return AesHelper.md5(string);
    }

    public static String getResource(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        File file = null;
        try {
            long l;
            String string2;
            String string3 = SocialResHelper.getMd5FileName(string) + ".tmp";
            if (DeviceConfig.isSdCardWrittenable()) {
                string2 = Environment.getExternalStorageDirectory().getCanonicalPath();
                l = 0x6400000L;
            } else {
                string2 = context.getCacheDir().getCanonicalPath();
                l = 0xA00000L;
            }
            File file2 = new File(string2 + CACHE_PATH);
            if (file2.exists()) {
                if (SocialResHelper.dirSize(file2.getCanonicalFile()) > l) {
                    SocialResHelper.cleanDir(file2);
                }
            } else if (!file2.mkdirs()) {
                Log.e(TAG, "Failed to create directory" + file2.getAbsolutePath() + ". Check permission. Make sure WRITE_EXTERNAL_STORAGE is added in your Manifest.xml");
            }
            file = new File(file2, string3);
            file.createNewFile();
            SocialResHelper.persistenceUrlData(string, file);
            File file3 = new File(file.getParent(), file.getName().replace(".tmp", ""));
            file.renameTo(file3);
            Log.i(TAG, "download img[" + string + "]  to " + file3.getCanonicalPath());
            return file3.getCanonicalPath();
        }
        catch (Exception exception) {
            Log.i(TAG, exception.getStackTrace().toString() + "\t url:\t" + string);
            if (file != null && file.exists()) {
                file.deleteOnExit();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void persistenceUrlData(String string, File file) {
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            inputStream = (InputStream)new URL(string).openConnection().getContent();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.d(TAG, iOException.getMessage());
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            Log.d(TAG, iOException.getMessage());
                        }
                    }
                }
            }
        }
    }

    private static long dirSize(File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return 0L;
        }
        long l = 0L;
        Stack<File> stack = new Stack<File>();
        stack.clear();
        stack.push(file);
        while (!stack.isEmpty()) {
            File file2 = (File)stack.pop();
            File[] fileArray = file2.listFiles();
            for (int j = 0; j < fileArray.length; ++j) {
                if (fileArray[j].isDirectory()) {
                    stack.push(fileArray[j]);
                    continue;
                }
                l += fileArray[j].length();
            }
        }
        return l;
    }

    private static void cleanDir(File file) {
        if (!(file != null && file.exists() && file.canWrite() && file.isDirectory())) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int j = 0; j < fileArray.length; ++j) {
            if (fileArray[j].isDirectory()) {
                SocialResHelper.cleanDir(fileArray[j]);
                continue;
            }
            if (new Date().getTime() - fileArray[j].lastModified() <= 1800L) continue;
            fileArray[j].delete();
        }
    }

    protected static File getCachedFile(Context context, String string) throws IOException {
        String string2 = SocialResHelper.getMd5FileName(string);
        String string3 = DeviceConfig.isSdCardWrittenable() ? Environment.getExternalStorageDirectory().getCanonicalPath() : context.getCacheDir().getCanonicalPath();
        File file = new File(string3 + CACHE_PATH);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    private static Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        int n = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        if (RESUTIL_V2_DUBUG) {
            canvas.drawRoundRect(rectF, (float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), paint);
        } else {
            canvas.drawRoundRect(rectF, (float)(bitmap.getWidth() / 6), (float)(bitmap.getHeight() / 6), paint);
        }
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        bitmap.recycle();
        return bitmap2;
    }

    public static enum FetchLocale {
        FETCH_FROM_LOCALE_CACHE,
        FETCH_FROM_NETWORK;

    }

    public static enum LoadMode {
        LOAD_CACHE_ELSE_NETWORK,
        LOAD_CACHE_ONLY,
        LOAD_NETWORK_ELSE_CACHE;

    }

    public static interface BindDrawableListener {
        public void onStart(LoadMode var1);

        public void onFetchStart(FetchLocale var1);

        public void onEnd(UResponse.STATUS var1, File var2, Drawable var3);
    }

    public static class Builder {
        Context mContext;
        ImageView mImageView;
        String mUrl;
        BindDrawableListener mBindListener;
        int mDefaultRid = -1;
        Animation mBindAnimation;
        LoadMode mLoadMode = LoadMode.LOAD_CACHE_ELSE_NETWORK;
        boolean mTransRoundCorner = false;
        boolean isBackground = false;

        public Builder(Context context, ImageView imageView, String string) {
            if (context == null || imageView == null || TextUtils.isEmpty((CharSequence)string)) {
                return;
            }
            this.mContext = context;
            this.mImageView = imageView;
            this.mUrl = string;
        }

        public Builder setBindListener(BindDrawableListener bindDrawableListener) {
            this.mBindListener = bindDrawableListener;
            return this;
        }

        public Builder setBindAnimation(Animation animation) {
            this.mBindAnimation = animation;
            return this;
        }

        public Builder setRoundCorner(boolean bl) {
            this.mTransRoundCorner = bl;
            return this;
        }

        public Builder setBindBackground(boolean bl) {
            this.isBackground = bl;
            return this;
        }

        public Builder setDefaultImg(int n) {
            this.mDefaultRid = n;
            return this;
        }

        public Builder setLoadMode(LoadMode loadMode) {
            this.mLoadMode = loadMode;
            return this;
        }

        public void doBindTask() {
            File file;
            block14: {
                file = null;
                try {
                    file = SocialResHelper.getCachedFile(this.mContext, this.mUrl);
                }
                catch (IOException iOException) {
                    Log.e(SocialResHelper.TAG, "can't get from cache.", iOException);
                    if (this.mBindListener == null) break block14;
                    this.mBindListener.onEnd(UResponse.STATUS.FAIL, null, null);
                }
            }
            Drawable drawable = null;
            switch (this.mLoadMode) {
                case LOAD_CACHE_ONLY: {
                    if (this.mBindListener != null) {
                        this.mBindListener.onStart(LoadMode.LOAD_CACHE_ONLY);
                        this.mBindListener.onFetchStart(FetchLocale.FETCH_FROM_LOCALE_CACHE);
                    }
                    if (file != null && file.exists()) {
                        drawable = Drawable.createFromPath((String)file.getAbsolutePath());
                        if (drawable == null) {
                            file.delete();
                        }
                        this.doBind(this.mContext, this.mImageView, drawable, this.isBackground, this.mBindListener, this.mBindAnimation, this.mTransRoundCorner, this.mDefaultRid);
                        break;
                    }
                    Log.e(SocialResHelper.TAG, "cache is not exists");
                    break;
                }
                case LOAD_CACHE_ELSE_NETWORK: {
                    if (this.mBindListener != null) {
                        this.mBindListener.onStart(LoadMode.LOAD_CACHE_ELSE_NETWORK);
                        this.mBindListener.onFetchStart(FetchLocale.FETCH_FROM_LOCALE_CACHE);
                    }
                    if (file != null && file.exists()) {
                        drawable = Drawable.createFromPath((String)file.getAbsolutePath());
                        if (drawable == null) {
                            file.delete();
                        }
                        this.doBind(this.mContext, this.mImageView, drawable, this.isBackground, this.mBindListener, this.mBindAnimation, this.mTransRoundCorner, this.mDefaultRid);
                        break;
                    }
                    this.fetchNetElsCache(drawable);
                    break;
                }
                case LOAD_NETWORK_ELSE_CACHE: {
                    if (this.mBindListener != null) {
                        this.mBindListener.onStart(LoadMode.LOAD_NETWORK_ELSE_CACHE);
                    }
                    this.fetchNetElsCache(drawable);
                }
            }
        }

        private void fetchNetElsCache(Drawable drawable) {
            if (drawable == null) {
                new AsyncTask<Object, Integer, Drawable>(){

                    protected void onPostExecute(Drawable drawable) {
                        Builder.this.doBind(Builder.this.mContext, Builder.this.mImageView, drawable, Builder.this.isBackground, Builder.this.mBindListener, Builder.this.mBindAnimation, Builder.this.mTransRoundCorner, Builder.this.mDefaultRid);
                    }

                    protected void onProgressUpdate(Integer ... integerArray) {
                        super.onProgressUpdate((Object[])integerArray);
                        if (integerArray == null || integerArray.length < 1) {
                            return;
                        }
                        switch (integerArray[0]) {
                            case 0: {
                                if (Builder.this.mBindListener == null) break;
                                Builder.this.mBindListener.onFetchStart(FetchLocale.FETCH_FROM_NETWORK);
                                break;
                            }
                            case 1: {
                                if (Builder.this.mBindListener == null) break;
                                Builder.this.mBindListener.onFetchStart(FetchLocale.FETCH_FROM_LOCALE_CACHE);
                            }
                        }
                    }

                    protected Drawable doInBackground(Object ... objectArray) {
                        try {
                            if (RESUTIL_V2_DUBUG) {
                                Thread.sleep(3000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.publishProgress(new Integer[]{0});
                        SocialResHelper.getResource(Builder.this.mContext, Builder.this.mUrl);
                        File file = null;
                        Drawable drawable = null;
                        try {
                            this.publishProgress(new Integer[]{1});
                            file = SocialResHelper.getCachedFile(Builder.this.mContext, Builder.this.mUrl);
                            if (file != null && file.exists() && (drawable = Drawable.createFromPath((String)file.getAbsolutePath())) == null) {
                                file.delete();
                            }
                        }
                        catch (IOException iOException) {
                            Log.w(SocialResHelper.TAG, iOException.toString());
                        }
                        return drawable;
                    }
                }.execute(new Object[0]);
            } else {
                this.doBind(this.mContext, this.mImageView, drawable, this.isBackground, this.mBindListener, this.mBindAnimation, this.mTransRoundCorner, this.mDefaultRid);
            }
        }

        private void doBind(Context context, ImageView imageView, Drawable drawable, boolean bl, BindDrawableListener bindDrawableListener, Animation animation, boolean bl2, int n) {
            Object object;
            if (drawable == null || imageView == null) {
                if (imageView != null && n > 0) {
                    imageView.setImageResource(n);
                }
                if (bindDrawableListener != null) {
                    bindDrawableListener.onEnd(UResponse.STATUS.FAIL, null, drawable);
                }
                Log.w(SocialResHelper.TAG, "bind drawable failed. drawable [" + drawable + "]  imageView[+" + imageView + "+]");
                return;
            }
            if (bl2) {
                object = ((BitmapDrawable)drawable).getBitmap();
                Bitmap bitmap = SocialResHelper.getRoundedCornerBitmap(object);
                drawable = new BitmapDrawable(context.getResources(), bitmap);
            }
            if (bl) {
                imageView.setBackground(drawable);
            } else {
                imageView.setImageDrawable(drawable);
            }
            if (animation != null) {
                imageView.startAnimation(animation);
            }
            object = null;
            try {
                object = SocialResHelper.getCachedFile(this.mContext, this.mUrl);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (bindDrawableListener != null) {
                bindDrawableListener.onEnd(UResponse.STATUS.SUCCESS, (File)object, drawable);
            }
        }
    }
}

