/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.register.mobile;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.sina.weibo.sdk.utils.ResourceManager;

public class LetterIndexBar
extends View {
    public static final int INDEX_COUNT_DEFAULT = 27;
    public static final String SEARCH_ICON_LETTER = "";
    private int mItemHeight;
    private Paint mPaint = new Paint();
    private String[] mIndexLetter;
    private boolean[] mNeedIndex;
    private int count = 27;
    private int mIndex;
    private OnIndexChangeListener mListener;
    private int mItemPadding;
    private boolean mTouching;
    private RectF mRect;
    private int mOrgTextSzie;
    private Drawable mSeatchIcon;

    public LetterIndexBar(Context context) {
        super(context);
        this.init();
    }

    public LetterIndexBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public LetterIndexBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(-10658467);
        this.mOrgTextSzie = ResourceManager.dp2px(this.getContext(), 13);
    }

    public void setIndexMark(boolean[] mark) {
        if (mark == null) {
            return;
        }
        this.mNeedIndex = mark;
        this.invalidate();
    }

    public void setIndexLetter(String[] letter) {
        if (letter == null) {
            return;
        }
        this.mIndexLetter = letter;
        this.count = this.mIndexLetter.length;
        this.mIndex = -1;
        this.invalidate();
    }

    public void setIndexChangeListener(OnIndexChangeListener listener) {
        this.mListener = listener;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mTouching) {
            int color = this.mPaint.getColor();
            this.mPaint.setColor(-2005436536);
            canvas.drawRoundRect(this.mRect, (float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredWidth() / 2), this.mPaint);
            this.mPaint.setColor(color);
        }
        int top = 0;
        int textSize = this.mOrgTextSzie;
        textSize = textSize > this.mItemHeight ? this.mItemHeight : this.mOrgTextSzie;
        this.mPaint.setTextSize((float)textSize);
        if (this.mIndexLetter == null) {
            char letter = 'A';
            int i = 0;
            while (i < this.count) {
                top = this.mItemHeight * i + this.getPaddingTop() + textSize + this.mItemPadding;
                if (this.mNeedIndex == null || this.mNeedIndex[i]) {
                    String title;
                    if (i == this.count - 1) {
                        title = "#";
                    } else {
                        char c = letter;
                        letter = (char)(c + 1);
                        title = String.valueOf(c);
                    }
                    int textWidth = (int)this.mPaint.measureText(title);
                    int left = (this.getMeasuredWidth() - textWidth) / 2;
                    canvas.drawText(title, (float)left, (float)top, this.mPaint);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                top = this.mItemHeight * i + this.getPaddingTop() + textSize + this.mItemPadding;
                if (this.mNeedIndex == null || this.mNeedIndex[i]) {
                    int left;
                    int textWidth;
                    String title = this.mIndexLetter[i];
                    if (title.equals(SEARCH_ICON_LETTER)) {
                        textWidth = (int)this.mPaint.measureText("M");
                        left = (this.getMeasuredWidth() - textWidth) / 2;
                        this.mSeatchIcon.setBounds(left, top - left, textWidth + left, textWidth + top - left);
                        this.mSeatchIcon.draw(canvas);
                    } else {
                        textWidth = (int)this.mPaint.measureText(title);
                        left = (this.getMeasuredWidth() - textWidth) / 2;
                        canvas.drawText(title, (float)left, (float)top, this.mPaint);
                    }
                }
                ++i;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mItemHeight = (height - this.getPaddingTop() - this.getPaddingBottom()) / this.count;
        this.mItemPadding = (int)(((float)this.mItemHeight - this.mPaint.getTextSize()) / 2.0f);
        int width = this.mOrgTextSzie + this.getPaddingLeft() + this.getPaddingRight();
        this.setMeasuredDimension(width, heightMeasureSpec);
        this.mRect = new RectF(0.0f, (float)this.getPaddingTop(), (float)this.getMeasuredWidth(), (float)(height - this.getPaddingTop() - this.getPaddingBottom()));
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 0: 
            case 2: {
                this.mTouching = true;
                int y = (int)event.getY();
                int index = (y - this.getPaddingTop()) / this.mItemHeight;
                if (index == this.mIndex || this.mNeedIndex != null && !this.mNeedIndex[index] || index >= this.count || index < 0) break;
                this.mIndex = index;
                if (this.mListener == null) break;
                this.mListener.onIndexChange(this.mIndex);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.mTouching = false;
                break;
            }
        }
        this.invalidate();
        return true;
    }

    public static interface OnIndexChangeListener {
        public void onIndexChange(int var1);
    }
}

