/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.component;

import android.app.Activity;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.component.ShareRequestParam;
import com.sina.weibo.sdk.component.WeiboSdkBrowser;
import com.sina.weibo.sdk.component.WeiboWebViewClient;
import com.sina.weibo.sdk.utils.Utility;

class ShareWeiboWebViewClient
extends WeiboWebViewClient {
    private static final String RESP_SUCC_CODE = "0";
    private static final String RESP_PARAM_CODE = "code";
    private static final String RESP_PARAM_MSG = "msg";
    private Activity mAct;
    private ShareRequestParam mShareRequestParam;
    private WeiboAuthListener mListener;

    public ShareWeiboWebViewClient(Activity activity, ShareRequestParam requestParam) {
        this.mAct = activity;
        this.mShareRequestParam = requestParam;
        this.mListener = requestParam.getAuthListener();
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (this.mCallBack != null) {
            this.mCallBack.onPageStartedCallBack(view, url, favicon);
        }
        super.onPageStarted(view, url, favicon);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (this.mCallBack != null) {
            this.mCallBack.shouldOverrideUrlLoadingCallBack(view, url);
        }
        if (url.startsWith("sinaweibo://browser/close")) {
            Bundle bundle = Utility.parseUri(url);
            if (!bundle.isEmpty() && this.mListener != null) {
                this.mListener.onComplete(bundle);
            }
            String errCode = bundle.getString(RESP_PARAM_CODE);
            String errMsg = bundle.getString(RESP_PARAM_MSG);
            if (TextUtils.isEmpty((CharSequence)errCode)) {
                this.mShareRequestParam.sendSdkCancleResponse(this.mAct);
            } else if (!RESP_SUCC_CODE.equals(errCode)) {
                this.mShareRequestParam.sendSdkErrorResponse(this.mAct, errMsg);
            } else {
                this.mShareRequestParam.sendSdkOkResponse(this.mAct);
            }
            WeiboSdkBrowser.closeBrowser(this.mAct, this.mShareRequestParam.getAuthListenerKey(), null);
            return true;
        }
        return super.shouldOverrideUrlLoading(view, url);
    }

    public void onPageFinished(WebView view, String url) {
        if (this.mCallBack != null) {
            this.mCallBack.onPageFinishedCallBack(view, url);
        }
        super.onPageFinished(view, url);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        if (this.mCallBack != null) {
            this.mCallBack.onReceivedErrorCallBack(view, errorCode, description, failingUrl);
        }
        this.mShareRequestParam.sendSdkErrorResponse(this.mAct, description);
        WeiboSdkBrowser.closeBrowser(this.mAct, this.mShareRequestParam.getAuthListenerKey(), null);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        if (this.mCallBack != null) {
            this.mCallBack.onReceivedSslErrorCallBack(view, handler, error);
        }
        handler.cancel();
        this.mShareRequestParam.sendSdkErrorResponse(this.mAct, "ReceivedSslError");
        WeiboSdkBrowser.closeBrowser(this.mAct, this.mShareRequestParam.getAuthListenerKey(), null);
    }
}

