/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.base;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.umeng.socialize.Config;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.common.ImageFormat;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.UMediaObject;
import com.umeng.socialize.net.base.SocializeReseponse;
import com.umeng.socialize.net.utils.AesHelper;
import com.umeng.socialize.net.utils.SocializeNetUtils;
import com.umeng.socialize.net.utils.SocializeProtocolConstants;
import com.umeng.socialize.net.utils.URequest;
import com.umeng.socialize.utils.DeviceConfig;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public abstract class SocializeRequest
extends URequest {
    public static final int REQUEST_SOCIAL = 0;
    public static final int REQUEST_ANALYTIC = 1;
    public static final int REQUEST_API = 2;
    protected Class<? extends SocializeReseponse> mResponseClz;
    protected Context mContext;
    private RequestMethod mMethod;
    private boolean mEncrypt = true;
    private Map<String, URequest.FilePair> mFileMap = new HashMap<String, URequest.FilePair>();
    private Map<String, String> mParams = new HashMap<String, String>();
    protected int mOpId;
    private int mReqType = 1;

    public SocializeRequest(Context context, String string, Class<? extends SocializeReseponse> clazz, int n, RequestMethod requestMethod) {
        super("");
        this.mResponseClz = clazz;
        this.mOpId = n;
        this.mContext = context;
        this.mMethod = requestMethod;
        AesHelper.setPassword(SocializeUtils.getAppkey(context));
    }

    public void setEncrypt(boolean bl) {
        this.mEncrypt = bl;
    }

    public void setReqType(int n) {
        this.mReqType = n;
    }

    public void addStringParams(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mParams.put(string, string2);
        }
    }

    public void addFileParams(byte[] byArray, FILE_TYPE fILE_TYPE, String string) {
        if (FILE_TYPE.IMAGE == fILE_TYPE) {
            String string2 = ImageFormat.checkFormat(byArray);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = "png";
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = System.currentTimeMillis() + "";
            }
            URequest.FilePair filePair = new URequest.FilePair(string + "" + string2, byArray);
            this.mFileMap.put(SocializeProtocolConstants.PROTOCOL_KEY_IMAGE, filePair);
        }
    }

    public void addMediaParams(UMediaObject uMediaObject) {
        Object object;
        if (uMediaObject == null) {
            return;
        }
        if (uMediaObject.isUrlMedia()) {
            object = uMediaObject.toUrlExtraParams();
            for (Map.Entry object2 : object.entrySet()) {
                this.addStringParams((String)object2.getKey(), object2.getValue().toString());
            }
        } else {
            object = uMediaObject.toByte();
            if (object != null) {
                this.addFileParams((byte[])object, FILE_TYPE.IMAGE, null);
            }
        }
        try {
            if (uMediaObject instanceof BaseMediaObject) {
                object = (BaseMediaObject)uMediaObject;
                String string = ((BaseMediaObject)object).getTitle();
                String string2 = ((BaseMediaObject)object).getThumb();
                if (!TextUtils.isEmpty((CharSequence)string) || !TextUtils.isEmpty((CharSequence)string2)) {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put(SocializeProtocolConstants.PROTOCOL_KEY_TITLE, (Object)string);
                    jSONObject.put(SocializeProtocolConstants.PROTOCOL_KEY_THUMB, (Object)string2);
                    this.addStringParams("ext", jSONObject.toString());
                }
            }
        }
        catch (Exception exception) {
            Log.e("can`t add qzone title & thumb. " + exception.getMessage());
        }
    }

    @Override
    public Map<String, Object> getBodyPair() {
        Map<String, Object> map = SocializeNetUtils.getBaseQuery(this.mContext);
        if (!TextUtils.isEmpty((CharSequence)Config.EntityKey)) {
            map.put("ek", Config.EntityKey);
        }
        if (!TextUtils.isEmpty((CharSequence)Config.SessionId)) {
            map.put("sid", Config.SessionId);
        }
        map.put("tp", this.mReqType);
        map.put("opid", this.mOpId);
        map.put("uid", Config.UID);
        map.putAll(this.mParams);
        if (Config.mEncrypt) {
            String string = this.mapTostring(map);
            Log.e("xxxxx", "raw=" + string);
            Log.i("--->", "unencrypt string: " + string);
            if (string != null) {
                try {
                    String string2 = AesHelper.encryptNoPadding(string, "UTF-8");
                    map.clear();
                    map.put("ud_post", string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        Log.e("xxxxx send~~=" + map);
        return map;
    }

    @Override
    public Map<String, URequest.FilePair> getFilePair() {
        return this.mFileMap;
    }

    @Override
    public JSONObject toJson() {
        return null;
    }

    @Override
    public String toGetUrl() {
        Map<String, Object> map = SocializeNetUtils.getBaseQuery(this.mContext);
        if (!TextUtils.isEmpty((CharSequence)Config.EntityKey)) {
            map.put("ek", Config.EntityKey);
        }
        if (!TextUtils.isEmpty((CharSequence)Config.SessionId)) {
            map.put("sid", Config.SessionId);
        }
        map.put("tp", this.mReqType);
        map.put("opid", this.mOpId);
        map.put("uid", Config.UID);
        map.putAll(this.mParams);
        return SocializeNetUtils.generateGetURL(this.getBaseUrl(), map);
    }

    @Override
    public void setBaseUrl(String string) {
        String string2;
        try {
            URL uRL = new URL(string);
            string2 = new URL(uRL, this.getPath()).toString();
        }
        catch (Exception exception) {
            throw new SocializeException("Can not generate correct url in SocializeRequest [" + this.getBaseUrl() + "]", exception);
        }
        super.setBaseUrl(string2);
    }

    protected abstract String getPath();

    @Override
    public void onPrepareRequest() {
        this.addStringParams("pcv", "2.0");
        String string = DeviceConfig.getDeviceId(this.mContext);
        this.addStringParams("imei", string);
        this.addStringParams("md5imei", AesHelper.md5(string));
        this.addStringParams("de", Build.MODEL);
        this.addStringParams("mac", DeviceConfig.getMac(this.mContext));
        this.addStringParams("os", "Android");
        this.addStringParams("en", DeviceConfig.getNetworkAccessMode(this.mContext)[0]);
        this.addStringParams("uid", null);
        this.addStringParams("sdkv", "5.0.0");
        this.addStringParams("dt", String.valueOf(System.currentTimeMillis()));
    }

    private String mapTostring(Map<String, Object> map) {
        if (this.mParams.isEmpty()) {
            return null;
        }
        try {
            return new JSONObject(map).toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    protected String getHttpMethod() {
        switch (this.mMethod) {
            case POST: {
                return POST;
            }
        }
        return GET;
    }

    protected static enum FILE_TYPE {
        IMAGE,
        VEDIO;

    }

    protected static enum RequestMethod {
        GET{

            public String toString() {
                return GET;
            }
        }
        ,
        POST{

            public String toString() {
                return POST;
            }
        };

    }
}

