/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.connect.common;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.tencent.connect.common.UIListenerManager;
import com.tencent.open.a.f;
import com.tencent.open.b.d;
import com.tencent.open.utils.Util;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.UiError;
import org.json.JSONObject;

public class AssistActivity
extends Activity {
    private static final String RESTART_FLAG = "RESTART_FLAG";
    private static final String TAG = "openSDK_LOG.AssistActivity";
    private boolean isRestart = false;
    public static final String EXTRA_INTENT = "openSDK_LOG.AssistActivity.ExtraIntent";
    protected static final int FINISH_BY_TIMEOUT = 0;
    private boolean canFinishByTimeout = false;
    private boolean canStartTimeout = false;
    protected Handler handler = new Handler(){

        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    if (AssistActivity.this.isFinishing()) break;
                    AssistActivity.this.finish();
                }
            }
        }
    };

    public static Intent getAssistActivityIntent(Context context) {
        Intent intent = new Intent(context, AssistActivity.class);
        return intent;
    }

    protected void onCreate(Bundle bundle) {
        Intent intent;
        this.requestWindowFeature(1);
        super.onCreate(bundle);
        this.setRequestedOrientation(3);
        f.b(TAG, "--onCreate--");
        if (this.getIntent() == null) {
            f.e(TAG, "-->onCreate--getIntent() returns null");
            this.finish();
        }
        int n2 = (intent = (Intent)this.getIntent().getParcelableExtra(EXTRA_INTENT)) == null ? 0 : intent.getIntExtra("key_request_code", 0);
        Bundle bundle2 = this.getIntent().getBundleExtra("h5_share_data");
        if (bundle != null) {
            this.isRestart = bundle.getBoolean(RESTART_FLAG);
        }
        if (!this.isRestart) {
            if (bundle2 == null) {
                if (intent != null) {
                    f.c(TAG, "--onCreate--activityIntent not null, will start activity, reqcode = " + n2);
                    if (intent.getComponent() != null) {
                        this.canFinishByTimeout = false;
                        this.startActivityForResult(intent, n2);
                    } else {
                        this.canFinishByTimeout = true;
                        this.canStartTimeout = false;
                        this.startActivity(intent);
                    }
                } else {
                    f.e(TAG, "--onCreate--activityIntent is null");
                    this.finish();
                }
            } else {
                f.d(TAG, "--onCreate--h5 bundle not null, will open browser");
                this.openBrowser(bundle2);
            }
        } else {
            f.b(TAG, "is restart");
        }
    }

    protected void onStart() {
        f.b(TAG, "-->onStart");
        super.onStart();
    }

    protected void onResume() {
        f.b(TAG, "-->onResume");
        super.onResume();
        Intent intent = this.getIntent();
        if (intent.getBooleanExtra("is_login", false)) {
            return;
        }
        if (!intent.getBooleanExtra("is_qq_mobile_share", false) && this.isRestart && !this.isFinishing()) {
            this.finish();
        }
        if (this.canFinishByTimeout && this.canStartTimeout) {
            Message message = this.handler.obtainMessage(0);
            this.handler.sendMessageDelayed(message, 200L);
        }
    }

    protected void onPause() {
        f.b(TAG, "-->onPause");
        if (this.canFinishByTimeout) {
            if (this.canStartTimeout) {
                this.handler.removeMessages(0);
            } else {
                this.canStartTimeout = true;
            }
        }
        super.onPause();
    }

    protected void onStop() {
        f.b(TAG, "-->onStop");
        super.onStop();
    }

    protected void onDestroy() {
        f.b(TAG, "-->onDestroy");
        super.onDestroy();
    }

    protected void onNewIntent(Intent intent) {
        f.c(TAG, "--onNewIntent");
        super.onNewIntent(intent);
        intent.putExtra("key_action", "action_share");
        this.setResult(-1, intent);
        if (!this.isFinishing()) {
            f.c(TAG, "--onNewIntent--activity not finished, finish now");
            this.finish();
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        f.b(TAG, "--onSaveInstanceState--");
        bundle.putBoolean(RESTART_FLAG, true);
        super.onSaveInstanceState(bundle);
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        f.c(TAG, "--onActivityResult--requestCode: " + n2 + " | resultCode: " + n3 + "data = null ? " + (intent == null));
        super.onActivityResult(n2, n3, intent);
        if (n2 == 0) {
            return;
        }
        if (intent != null) {
            intent.putExtra("key_action", "action_login");
        }
        this.setResultData(n3, intent);
        this.finish();
    }

    public void setResultData(int n2, Intent intent) {
        if (intent == null) {
            f.d(TAG, "--setResultData--intent is null, setResult ACTIVITY_CANCEL");
            this.setResult(0, intent);
            return;
        }
        try {
            String string = intent.getStringExtra("key_response");
            f.b(TAG, "--setResultDataForLogin-- " + string);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                JSONObject jSONObject = new JSONObject(string);
                String string2 = jSONObject.optString("openid");
                String string3 = jSONObject.optString("access_token");
                if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
                    f.c(TAG, "--setResultData--openid and token not empty, setResult ACTIVITY_OK");
                    this.setResult(-1, intent);
                } else {
                    f.d(TAG, "--setResultData--openid or token is empty, setResult ACTIVITY_CANCEL");
                    this.setResult(0, intent);
                }
            } else {
                f.d(TAG, "--setResultData--response is empty, setResult ACTIVITY_OK");
                this.setResult(-1, intent);
            }
        }
        catch (Exception exception) {
            f.e(TAG, "--setResultData--parse response failed");
            exception.printStackTrace();
        }
    }

    private void openBrowser(Bundle bundle) {
        String string = bundle.getString("viaShareType");
        String string2 = bundle.getString("callbackAction");
        String string3 = bundle.getString("url");
        String string4 = bundle.getString("openId");
        String string5 = bundle.getString("appId");
        String string6 = "";
        String string7 = "";
        if ("shareToQQ".equals(string2)) {
            string6 = "ANDROIDQQ.SHARETOQQ.XX";
            string7 = "10";
        } else if ("shareToQzone".equals(string2)) {
            string6 = "ANDROIDQQ.SHARETOQZ.XX";
            string7 = "11";
        }
        boolean bl = Util.openBrowser((Context)this, string3);
        if (!bl) {
            IUiListener iUiListener = UIListenerManager.getInstance().getListnerWithAction(string2);
            if (null != iUiListener) {
                iUiListener.onError(new UiError(-6, "\u6253\u5f00\u6d4f\u89c8\u5668\u5931\u8d25!", null));
            }
            d.a().a(string4, string5, string6, string7, "3", "1", string, "0", "2", "0");
            this.finish();
        } else {
            d.a().a(string4, string5, string6, string7, "3", "0", string, "0", "2", "0");
        }
        this.getIntent().removeExtra("shareH5");
    }
}

