/*
 * Decompiled with CFR 0.152.
 */
package com.android.hotpatch.utils;

import android.content.Context;
import android.util.Log;
import com.android.hotpatch.framework.ChangeQuickRedirect;
import com.android.hotpatch.framework.PatchedClassInfo;
import com.android.hotpatch.framework.PatchesInfo;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.NoSuchElementException;

public class PatchUtils {
    public static boolean saveFile(String httpUrl, String localPath) {
        int bufSize = 1024;
        try {
            URL url = new URL(httpUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            InputStream is = connection.getInputStream();
            File file = new File(localPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream os = new FileOutputStream(file);
            byte[] buffer = new byte[bufSize];
            int hasRead = 0;
            while ((hasRead = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, hasRead);
            }
            is.close();
            ((OutputStream)os).close();
            connection.disconnect();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean loadDex(Context context, String patchDexPath, String patchesInfoImplClass) {
        File dexFile = new File(patchDexPath);
        if (!dexFile.exists()) {
            return false;
        }
        try {
            File odexDir = new File(context.getFilesDir() + File.separator + "odex" + File.separator);
            if (!odexDir.exists()) {
                odexDir.mkdirs();
            }
            DexClassLoader mLoader = new DexClassLoader(dexFile.getAbsolutePath(), odexDir.getAbsolutePath(), null, context.getClassLoader());
            Class patchInfoClazz = mLoader.loadClass(patchesInfoImplClass);
            PatchesInfo patchInfo = (PatchesInfo)patchInfoClazz.newInstance();
            List<PatchedClassInfo> infoList = patchInfo.getPatchedClassesInfo();
            for (PatchedClassInfo info : infoList) {
                ChangeQuickRedirect redirectObj = (ChangeQuickRedirect)mLoader.loadClass(info.getPatchClassName()).newInstance();
                Class fixClass = mLoader.loadClass(info.getFixClassName());
                Field redirectF = fixClass.getField("changeQuickRedirect");
                redirectF.set(null, redirectObj);
            }
            System.out.println("patch success");
            return true;
        }
        catch (Throwable e) {
            System.err.println("load patch error:" + Log.getStackTraceString((Throwable)e));
            return false;
        }
    }

    public static Object getStaticPrivateField(Class targetClass, String fieldName) {
        return PatchUtils.getPrivateField(null, targetClass, fieldName);
    }

    public static void setStaticPrivateField(Object value, Class targetClass, String fieldName) {
        PatchUtils.setPrivateField(null, value, targetClass, fieldName);
    }

    public static void setPrivateField(Object targetObject, Object value, Class targetClass, String fieldName) {
        try {
            Field declaredField = PatchUtils.getField(targetClass, fieldName);
            declaredField.set(targetObject, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getPrivateField(Object targetObject, Class targetClass, String fieldName) {
        try {
            Field declaredField = PatchUtils.getField(targetClass, fieldName);
            return declaredField.get(targetObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Field getField(Class target, String name) {
        Field declareField = PatchUtils.getFieldByName(target, name);
        if (declareField == null) {
            throw new RuntimeException(new NoSuchElementException(name));
        }
        declareField.setAccessible(true);
        return declareField;
    }

    public static Object invokeProtectedMethod(Object receiver, Object[] params, Class[] parameterTypes, String methodName) throws Throwable {
        try {
            Method toDispatchTo = PatchUtils.getMethodByName(receiver.getClass(), methodName, parameterTypes);
            if (toDispatchTo == null) {
                throw new RuntimeException(new NoSuchMethodException(methodName));
            }
            toDispatchTo.setAccessible(true);
            return toDispatchTo.invoke(receiver, params);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeProtectedStaticMethod(Object[] params, Class[] parameterTypes, String methodName, Class receiverClass) throws Throwable {
        try {
            Method toDispatchTo = PatchUtils.getMethodByName(receiverClass, methodName, parameterTypes);
            if (toDispatchTo == null) {
                throw new RuntimeException(new NoSuchMethodException(methodName + " in class " + receiverClass.getName()));
            }
            toDispatchTo.setAccessible(true);
            return toDispatchTo.invoke(null, params);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getFieldByName(Class<?> aClass, String name) {
        for (Class<?> currentClass = aClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private static Method getMethodByName(Class<?> aClass, String name, Class[] paramTypes) {
        if (aClass == null) {
            return null;
        }
        for (Class<?> currentClass = aClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredMethod(name, paramTypes);
            }
            catch (NoSuchMethodException localNoSuchMethodException) {
                if (currentClass != null) continue;
            }
        }
        return null;
    }
}

