/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import com.umeng.socialize.net.utils.AesHelper;
import com.umeng.socialize.utils.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;

public class BitmapUtils {
    public static final String FOLDER = "umeng_cache";
    public static String PATH = "/mnt/sdcard/";
    public static final int COMPRESS_FLAG = 0x300000;
    private static final String TAG = "BitmapUtils";
    private static final int MB = 0x100000;
    private static final int FREE_SD_SPACE = 40;
    private static final int CACHE_SIZE = 10;
    public static int MAX_WIDTH;
    public static int MAX_HEIGHT;

    public static void init() {
        boolean bl = Environment.getExternalStorageState().equals("mounted");
        PATH = bl ? Environment.getExternalStorageDirectory().getPath() + File.separator + FOLDER + File.separator : Environment.getDataDirectory().getPath() + File.separator + FOLDER + File.separator;
        File file = new File(PATH);
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            BitmapUtils.remove40PercentCache(PATH);
            file = null;
        }
        catch (Exception exception) {
            Log.d(TAG, "\u6e05\u9664\u7f13\u5b58\u629b\u51fa\u5f02\u5e38 \uff1a " + exception.toString());
        }
        System.gc();
    }

    private static BitmapFactory.Options getScaleBitmapOptions(String string, int n, int n2) {
        InputStream inputStream = BitmapUtils.getBitmapStream(string);
        if (inputStream == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            int n3 = (int)Math.ceil(options.outHeight / n2);
            int n4 = (int)Math.ceil(options.outWidth / n);
            if (n3 > 1 && n4 > 1) {
                options.inSampleSize = n3 > n4 ? n3 : n4;
            }
            options.inJustDecodeBounds = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BitmapUtils.closeInputStream(inputStream);
        return options;
    }

    private static InputStream getBitmapStream(String string) {
        InputStream inputStream = null;
        try {
            try {
                boolean bl = true;
                if (bl) {
                    inputStream = new FileInputStream(new File(BitmapUtils.getFileName(string)));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (inputStream == null || inputStream.available() <= 0) {
                inputStream = new URL(string).openStream();
                BitmapUtils.saveInputStream(BitmapUtils.getFileName(string), inputStream);
                inputStream = new FileInputStream(new File(BitmapUtils.getFileName(string)));
            }
        }
        catch (Exception exception) {
            Log.e("BitmapUtil", "\u8bfb\u53d6\u56fe\u7247\u6d41\u51fa\u9519" + exception.toString());
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveInputStream(String string, InputStream inputStream) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(string));
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap loadImage(String string, int n, int n2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Bitmap bitmap = null;
        InputStream inputStream = null;
        try {
            inputStream = BitmapUtils.getBitmapStream(string);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)BitmapUtils.getScaleBitmapOptions(string, n, n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            BitmapUtils.closeInputStream(inputStream);
        }
        return bitmap;
    }

    public static boolean isFileExist(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        File file = new File(BitmapUtils.getFileName(string));
        return file.exists();
    }

    public static boolean isNeedScale(String string, int n) {
        File file = new File(BitmapUtils.getFileName(string));
        return file.exists() && file.length() >= (long)n;
    }

    public static Bitmap getBitmapFromFile(String string) {
        InputStream inputStream = BitmapUtils.getBitmapStream(string);
        if (inputStream == null) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, null);
        BitmapUtils.closeInputStream(inputStream);
        return bitmap;
    }

    public static Bitmap getBitmapFromFile(String string, int n, int n2) {
        InputStream inputStream = BitmapUtils.getBitmapStream(string);
        if (inputStream == null) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)BitmapUtils.getScaleBitmapOptions(string, n, n2));
        BitmapUtils.closeInputStream(inputStream);
        return bitmap;
    }

    public static void saveBitmap(String string, Bitmap bitmap) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(BitmapUtils.getFileName(string)));
            int n = 100;
            if (bitmap.getRowBytes() * bitmap.getHeight() > 0x300000) {
                n = 80;
            }
            bitmap.compress(Bitmap.CompressFormat.PNG, n, (OutputStream)bufferedOutputStream);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                Log.d(TAG, exception.toString());
            }
        }
    }

    public static String getFileName(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        String string2 = string;
        if (string.startsWith("http://") || string.startsWith("https://")) {
            string2 = PATH + AesHelper.md5(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bitmap2Bytes(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (bitmap == null || bitmap.isRecycled()) {
            Log.d(TAG, "bitmap2Bytes  ==> bitmap == null or bitmap.isRecycled()");
            return null;
        }
        try {
            byte[] byArray;
            byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byArray = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (Exception exception) {
            Log.e(TAG, exception.toString());
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static BitmapFactory.Options getBitmapOptions(byte[] byArray) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
        int n = (int)Math.ceil(options.outWidth / MAX_WIDTH);
        int n2 = (int)Math.ceil(options.outHeight / MAX_HEIGHT);
        if (n2 > 1 && n > 1) {
            options.inSampleSize = n2 > n ? n2 : n;
        } else if (n2 > 2) {
            options.inSampleSize = n2;
        } else if (n > 2) {
            options.inSampleSize = n;
        }
        options.inJustDecodeBounds = false;
        return options;
    }

    private static int freeSpaceOnSd() {
        StatFs statFs = new StatFs(Environment.getExternalStorageDirectory().getPath());
        double d2 = (double)statFs.getAvailableBlocks() * (double)statFs.getBlockSize() / 1048576.0;
        return (int)d2;
    }

    private static void remove40PercentCache(String string) {
        int n;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < fileArray.length; ++n) {
            n2 = (int)((long)n2 + fileArray[n].length());
        }
        if (n2 > 0xA00000 || 40 > BitmapUtils.freeSpaceOnSd()) {
            n = (int)(0.4 * (double)fileArray.length + 1.0);
            Arrays.sort(fileArray, new FileLastModifSort());
            for (int j = 0; j < n; ++j) {
                fileArray[j].delete();
            }
        }
    }

    public static void cleanCache() {
        BitmapUtils.init();
    }

    public static byte[] compressBitmap(byte[] byArray, int n) {
        boolean bl = false;
        if (byArray != null && byArray.length >= n) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            int n2 = 1;
            double d2 = 1.0;
            while (!bl && n2 <= 10) {
                d2 = Math.pow(0.8, n2);
                int n3 = (int)(100.0 * d2);
                Log.d(TAG, "quality = " + n3);
                bitmap.compress(Bitmap.CompressFormat.JPEG, n3, (OutputStream)byteArrayOutputStream);
                Log.d(TAG, "WeiXin Thumb Size = " + byteArrayOutputStream.toByteArray().length / 1024 + " KB");
                if (byteArrayOutputStream != null && byteArrayOutputStream.size() < n) {
                    bl = true;
                    continue;
                }
                byteArrayOutputStream.reset();
                ++n2;
            }
            if (byteArrayOutputStream != null) {
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                if (!bitmap.isRecycled()) {
                    bitmap.recycle();
                }
                if (byArray2 != null && byArray2.length <= 0) {
                    Log.e(TAG, "### \u60a8\u7684\u539f\u59cb\u56fe\u7247\u592a\u5927,\u5bfc\u81f4\u7f29\u7565\u56fe\u538b\u7f29\u8fc7\u540e\u8fd8\u5927\u4e8e32KB,\u8bf7\u5c06\u5206\u4eab\u5230\u5fae\u4fe1\u7684\u56fe\u7247\u8fdb\u884c\u9002\u5f53\u7f29\u5c0f.");
                }
                return byArray2;
            }
        }
        return byArray;
    }

    public static Bitmap createThumb(Bitmap bitmap, float f2) {
        Bitmap bitmap2 = null;
        if (bitmap != null && !bitmap.isRecycled()) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            float f3 = 1.0f;
            if (n < 200 || n2 < 200) {
                f3 = n < n2 ? f2 / (float)n : f2 / (float)n2;
            }
            if ((bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)(f3 * (float)n)), (int)((int)(f3 * (float)n2)), (boolean)true)) == null) {
                bitmap2 = bitmap;
            }
        }
        return bitmap2;
    }

    static {
        BitmapUtils.init();
        MAX_WIDTH = 768;
        MAX_HEIGHT = 1024;
    }

    private static class FileLastModifSort
    implements Comparator<File> {
        private FileLastModifSort() {
        }

        @Override
        public int compare(File file, File file2) {
            if (file.lastModified() > file2.lastModified()) {
                return 1;
            }
            if (file.lastModified() == file2.lastModified()) {
                return 0;
            }
            return -1;
        }
    }
}

